Imports System.Web.Services


<WebService(Description:="Represents a user-defined number of Dice, with random roll values.", _
  Name:="Dice", Namespace:="http://www.softconcepts.com/")> _
Public Class Service1
  Inherits System.Web.Services.WebService

#Region " Web Services Designer Generated Code "

  Public Sub New()
    MyBase.New()

    'This call is required by the Web Services Designer.
    InitializeComponent()

    'Add your own initialization code after the InitializeComponent() call
  End Sub

  'Required by the Web Services Designer
  Private components As System.ComponentModel.IContainer

  'NOTE: The following procedure is required by the Web Services Designer
  'It can be modified using the Web Services Designer.  
  'Do not modify it using the code editor.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
    components = New System.ComponentModel.Container()
  End Sub

  Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
    'CODEGEN: This procedure is required by the Web Services Designer
    'Do not modify it using the code editor.
    If disposing Then
      If Not (components Is Nothing) Then
        components.Dispose()
      End If
    End If
    MyBase.Dispose(disposing)
  End Sub

#End Region

  ' WEB SERVICE EXAMPLE
  ' The HelloWorld() example service returns the string Hello World.
  ' To build, uncomment the following lines then save and build the project.
  ' To test this web service, ensure that the .asmx file is the start page
  ' and press F5.
  '
  '<WebMethod()> Public Function HelloWorld() As String
  '	HelloWorld = "Hello World"
  ' End Function

  <WebMethod(Description:="Returns an array of random values representing six-sided dice.", _
    EnableSession:=True)> _
  Public Function Roll(ByVal HowMany As Integer) As Integer()
    Dim DiceValues(HowMany) As Integer
    Dim R As New Random()

    Dim I As Integer
    For I = 0 To DiceValues.Length - 1
      DiceValues(I) = R.Next(1, 7)
    Next

    UpdateAverage(DiceValues)

    Return DiceValues
  End Function

  <WebMethod(EnableSession:=True)> _
  Public Function GetCount() As Integer
    Return Count
  End Function

  <WebMethod(EnableSession:=True)> _
  Public Function GetSum() As Integer
    Return Sum
  End Function

  Private Property Count() As Integer
    Get
      Return CInt(Session("Count"))
    End Get

    Set(ByVal Value As Integer)
      Session("Count") = Value
    End Set

  End Property

  Private Property Sum() As Integer
    Get
      Return CInt(Session("Sum"))
    End Get
    Set(ByVal Value As Integer)
      Session("Sum") = Value
    End Set
  End Property

  <WebMethod(EnableSession:=True)> _
  Private Sub UpdateAverage(ByVal Values() As Integer)
    Count += 1

    Dim I As Integer
    For I = 0 To Values.Length - 1
      Sum += Values(I)
    Next

  End Sub

  <WebMethod(EnableSession:=True)> _
  Public Function AverageRoll() As Integer

    'Try
    '  Return Sum \ Count
    'Catch
    '  Return 0
    'End Try

    Try
      Return Sum \ Count
    Catch e As Exception
      Throw e
    End Try
  End Function

End Class
